﻿using gov.va.med.vbecs.GUI;
using gov.va.med.vbecs.GUI.controls;
using System.ComponentModel;

namespace WPF.PresentationLayer.UC115.ViewModels
{
    public class PatientInfoBarViewModel : ViewModelBase
    {
        public DelegateCommand SpecialInstructionsCommand { get; set; }
        public DelegateCommand BloodAvailabilityCommand { get; set; }
        public DelegateCommand RecentOrdersCommand { get; set; }
        public DelegateCommand MedicationsCommand { get; set; }
        public DelegateCommand TransfusionReactionHistoryCommand { get; set; }
        public DelegateCommand RecentTransfusionsIssuesCommand { get; set; }
        
        private PatientInfoToolbarBase patientInfoToolbarBase;
        public PatientInfoToolbarBase PatientInfoToolbarBase
        {
            get
            {
                return patientInfoToolbarBase;
            }
            set
            {
                patientInfoToolbarBase = value;
                RaisePropertyChanged(() => PatientInfoToolbarBase);
            }
        }

        public PatientInfoBarViewModel(gov.va.med.vbecs.BOL.Patient patient, VbecsBaseForm vbecsBaseForm)
        {
            SetVbecsBaseForm(vbecsBaseForm, false);

            PatientInfoToolbarBase = new PatientInfoToolbarBase();
            PatientInfoToolbarBase.Patient = patient;
            PatientInfoToolbarBase.PropertyChanged += PatientInfoToolbarBase_PropertyChanged;

            vbecsBaseForm.FormClosed += vbecsBaseForm_FormClosed;

            SpecialInstructionsCommand = new DelegateCommand(OnSpecialInstructionsCommand, () => PatientInfoToolbarBase.EnabledSIAndTRButton);
            BloodAvailabilityCommand = new DelegateCommand(OnBloodAvailabilityCommand, () => PatientInfoToolbarBase.EnabledBloodAvailButton);
            RecentOrdersCommand = new DelegateCommand(OnRecentOrdersCommand, () => PatientInfoToolbarBase.EnabledRecentOrdersButton);
            MedicationsCommand = new DelegateCommand(OnMedicationsCommand, () => PatientInfoToolbarBase.EnabledMedicationButton);
            TransfusionReactionHistoryCommand = new DelegateCommand(OnTransfusionReactionHistoryCommand, () => PatientInfoToolbarBase.EnabledTransfusionReactionHistoryButton);
            RecentTransfusionsIssuesCommand = new DelegateCommand(OnRecentTransfusionsIssuesCommand, () => PatientInfoToolbarBase.EnabledRecentTransfusionsIssuesButton);            
        }

        void vbecsBaseForm_FormClosed(object sender, System.Windows.Forms.FormClosedEventArgs e)
        {
            if (VbecsBaseForm != null)
            {
                PatientInfoToolbarBase.PropertyChanged -= PatientInfoToolbarBase_PropertyChanged;
                VbecsBaseForm.FormClosed -= vbecsBaseForm_FormClosed;
            }
        }

        void PatientInfoToolbarBase_PropertyChanged(object sender, PropertyChangedEventArgs e)
        {
            SpecialInstructionsCommand.RaiseCanExecuteChanged();
            BloodAvailabilityCommand.RaiseCanExecuteChanged();
            RecentOrdersCommand.RaiseCanExecuteChanged();
            MedicationsCommand.RaiseCanExecuteChanged();
            TransfusionReactionHistoryCommand.RaiseCanExecuteChanged();
            RecentTransfusionsIssuesCommand.RaiseCanExecuteChanged();
        }

        private void OnRecentTransfusionsIssuesCommand()
        {
            PatientInfoToolbarBase.OnRecentTransfusionsIssuesClick(VbecsBaseForm);
        }

        private void OnTransfusionReactionHistoryCommand()
        {
            PatientInfoToolbarBase.OnTransfusionReactionHistoryClick(VbecsBaseForm);
        }

        private void OnRecentOrdersCommand()
        {
            PatientInfoToolbarBase.OnRecentOrdersClick(VbecsBaseForm);
        }

        private void OnMedicationsCommand()
        {
            PatientInfoToolbarBase.OnCurrentMedsClick(VbecsBaseForm);
        }

        private void OnBloodAvailabilityCommand()
        {
            PatientInfoToolbarBase.OnBloodAvailabilityClick(VbecsBaseForm);            
        }

        private void OnSpecialInstructionsCommand()
        {
            PatientInfoToolbarBase.OnSpecialInstructionsClick(VbecsBaseForm);
        }
    }
}
